#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;

CreateWallsDB(start,end)
{
	D=Distance((start[0],start[1],0),(end[0],end[1],0));
	H=Distance((0,0,start[2]),(0,0,end[2]));
	blocks=roundUp(D/55);
	height=roundUp(H/30);
	CX=end[0] - start[0];
	CY=end[1] - start[1];
	CZ=end[2] - start[2];
	XA =(CX/blocks);
	YA =(CY/blocks);
	ZA =(CZ/height);
	TXA =(XA/4);
	TYA =(YA/4);
	Temp=VectorToAngles(end - start);
	Angle =(0,Temp[1],90);
	for(h=0;h < height;h++)
	{
		block=spawn("script_model",(start +(TXA,TYA,10)+((0,0,ZA)* h)));
		//block setModel("com_plasticcase_friendly");
		block.angles=Angle;
		block Solid();
		block hide();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
		for(i=1;i < blocks;i++)
		{
			block=spawn("script_model",(start +((XA,YA,0)* i)+(0,0,10)+((0,0,ZA)* h)));
			//block setModel("com_plasticcase_friendly");
			block.angles=Angle;
			block Solid();
			block hide();
			block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
			
		}
		block=spawn("script_model",((end[0],end[1],start[2])+(TXA * -1,TYA * -1,10)+((0,0,ZA)* h)));
		//block setModel("com_plasticcase_friendly");
		block.angles=Angle;
		block Solid();
		block hide();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
	}
	level.Level_DBBuilt=1;
}
CreateWallsDB2(start,end)
{
	D=Distance((start[0],start[1],0),(end[0],end[1],0));
	H=Distance((0,0,start[2]),(0,0,end[2]));
	blocks=roundUp(D/55);
	height=roundUp(H/30);
	CX=end[0] - start[0];
	CY=end[1] - start[1];
	CZ=end[2] - start[2];
	XA =(CX/blocks);
	YA =(CY/blocks);
	ZA =(CZ/height);
	TXA =(XA/4);
	TYA =(YA/4);
	Temp=VectorToAngles(end - start);
	Angle =(0,Temp[1],90);
	for(h=0;h < height;h++)
	{
		block=spawn("script_model",(start +(TXA,TYA,10)+((0,0,ZA)* h)));
		block setModel("com_plasticcase_enemy");
		block.angles=Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
		for(i=1;i < blocks;i++)
		{
			block=spawn("script_model",(start +((XA,YA,0)* i)+(0,0,10)+((0,0,ZA)* h)));
			block setModel("com_plasticcase_enemy");
			block.angles=Angle;
			block Solid();
			block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
			
		}
		block=spawn("script_model",((end[0],end[1],start[2])+(TXA * -1,TYA * -1,10)+((0,0,ZA)* h)));
		block setModel("com_plasticcase_enemy");
		block.angles=Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
	}
	wait 3;
	level notify("Level_DBBuilt");
	level.Level_DBBuilt=1;
}
CreateWallsDB3(start,end)
{
	D=Distance((start[0],start[1],0),(end[0],end[1],0));
	H=Distance((0,0,start[2]),(0,0,end[2]));
	blocks=roundUp(D/55);
	height=roundUp(H/30);
	CX=end[0] - start[0];
	CY=end[1] - start[1];
	CZ=end[2] - start[2];
	XA =(CX/blocks);
	YA =(CY/blocks);
	ZA =(CZ/height);
	TXA =(XA/4);
	TYA =(YA/4);
	Temp=VectorToAngles(end - start);
	Angle =(0,Temp[1],90);
	for(h=0;h < height;h++)
	{
		block=spawn("script_model",(start +(TXA,TYA,10)+((0,0,ZA)* h)));
		block setModel("tag_origin");
		block.angles = (90,90,0);
		block thread doAltfire(block.origin);
		//block.angles=Angle;
		//block Solid();
		//block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
		for(i=1;i < blocks;i++)
		{
			block=spawn("script_model",(start +((XA,YA,0)* i)+(0,0,10)+((0,0,ZA)* h)));
			block setModel("tag_origin");
			block.angles = (90,90,0);
			block thread doAltfire(block.origin);
			//block.angles=Angle;
			//block Solid();
			//block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
			
		}
		block=spawn("script_model",((end[0],end[1],start[2])+(TXA * -1,TYA * -1,10)+((0,0,ZA)* h)));
		block setModel("tag_origin");
		block.angles = (90,90,0);
		//block thread doAltfire(block.origin);
		playFX(level.customFX["raygun_laser"], block.origin-(0,0,40));
		//block.angles=Angle;
		//block Solid();
		//block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
		
	}
	wait 3;
	level notify("Level_DBBuilt");
	level.Level_DBBuilt=1;
}
doAltfire(pos)
{	
	self endon("disconnect");
	while(isDefined(self))//GOOD
	{
		playFX(level.customFX["raygun_laser"], pos-(0,0,40));
		wait 1;
	}
}

/*
	level.customFX["raygun_laser"]=				loadfx( "vfx/props/claymore_laser" );//Updated for HMW
	level.customFX["fire_smoke"]=				loadfx( "fx/fire/fire_smoke_trail_l");//Updated for HMW
	level.customFX["fire_ball"]=				loadfx( "vfx/trail/trail_fire_smoke_l");//Updated for HMW
	level.customFX["large_vehicle_explosion"]=	loadfx( "explosions/large_vehicle_explosion");//Updated for HMW
	level.customFX["force_field"]=				loadfx( "fx/fire/jet_afterburner_harrier" );//Updated for HMW
	level.customFX["red_blink_light"]=			loadfx( "vfx/lights/light_c4_blink");//Updated for HMW
	level.customFX["mine_flash"]=				loadfx( "vfx/explosion/frag_grenade_flash" );//Updated for HMW
	level.customFX["mine_explosion"]=			loadfx( "fx/explosions/artilleryexp_dirt_brown_2");//Updated for HMW
*/
roundUp( floatVal ) 
{
	if(int( floatVal) != floatVal)
		return int( floatVal+1 ); 
	else 
		return int( floatVal );
}
CreateGridsDB(corner1,corner2,angle)
{
	setdvar("timescale",5);
	W=Distance((corner1[0],0,0),(corner2[0],0,0));
	L=Distance((0,corner1[1],0),(0,corner2[1],0));
	H=Distance((0,0,corner1[2]),(0,0,corner2[2]));
	CX=corner2[0] - corner1[0];
	CY=corner2[1] - corner1[1];
	CZ=corner2[2] - corner1[2];
	ROWS=roundUp(W/55);
	COLUMNS=roundUp(L/30);
	HEIGHT=roundUp(H/20);
	XA=CX/ROWS;
	YA=CY/COLUMNS;
	ZA=CZ/HEIGHT;
	level.AddingCounter=0;
	center=spawn("script_model",corner1);
	for(r=0;r<=ROWS;r++)
	{
		for(c=0;c<=COLUMNS;c++)
		{
			for(h=0;h<=HEIGHT;h++)
			{
				block=spawn("script_model",(corner1 +(XA * r,YA * c,ZA * h)));
				block setModel("com_plasticcase_friendly");
				level.AddingCounter++;
				//iprintln(level.AddingCounter);
				if(!isSpecialBlock(level.AddingCounter))
				{
					block hide();
				}
				block.angles =(0,0,0);
				block Solid();
				block LinkTo(center);
				block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
				
			}
		}
	}
	setdvar("timescale",1);
	center.angles=angle;
}

isSpecialBlock(BS)
{
    switch(BS)
    {
		case 231:
		case 232:
		case 233:
		case 234:
		case 235:
		case 236:
		case 237:
		case 238:
		case 239:
		case 240:
		case 241:
		case 242:
		case 243:
		case 244:
		case 245:
		case 246:
		case 247:
		case 248:
		case 249:
		case 250:
		case 251:
		case 252:
		case 208:
		case 209:
		case 210:
		case 211:
		case 212:
		case 213:
		case 214:
		case 215:
		case 216:
		case 217:
		case 218:
		case 219:
		case 220:
		case 221:
		case 222:
		case 223:
		case 224:
		case 225:
		case 226:
		case 227:
		case 228:
		case 229:
		case 230:
		case 1:
		case 2:
		case 3:
		case 4:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
		case 10:
		case 11:
		case 12:
		case 13:
		case 14:
		case 15:
		case 16:
		case 17:
		case 18:
		case 19:
		case 20:
		case 21:
		case 22:
		case 24:
		case 47:
		case 70:
		case 93:
		case 23:
		case 46:
		case 69:
		case 92:
		case 116:
		case 139:
		case 162:
		case 185:
		case 254:
		case 277:
		case 300:
		case 323:
		case 346:
		case 369:
		case 392:
		case 438:
		case 462:
		case 115:
		case 138:
		case 161:
		case 184:
		case 207:
		case 253:
		case 276:
		case 299:
		case 322:
		case 345:
		case 368:
		case 391:
		case 414:
		case 415:
		case 437:
		case 439:
		case 440:
		case 441:
		case 442:
		case 443:
		case 444:
		case 445:
		case 446:
		case 447:
		case 448:
		case 449:
		case 450:
		case 451:
		case 452:
		case 453:
		case 454:
		case 455:
		case 456:
		case 457:
		case 458:
		case 459:
		case 460:
            return true;
        
        default:
            return false;
    }
} 